<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $guarded = array('id', 'remember_token', 'timestamps');

    public function ville()
    {
        return $this->belongsTo('App\Model\Ville');
    }

    public function notifications()
    {
        return $this->hasMany('App\Model\Notification');
    }

    public function commentaires()
    {
        return $this->hasMany('App\Model\Commentaire');
    }

    public function preinscriptions()
    {
        return $this->belongsToMany('App\Model\Covoiturage');
    }

    public function inscriptions()
    {
        return $this->belongsToMany('App\Model\Covoiturage');
    }

    public function conducteurCovoiturages()
    {
        return $this->hasMany('App\Model\Covoiturage', 'conducteur_id');
    }

    public function notesRecu()
    {
        return $this->hasMany('App\Model\Note', 'notee_id');
    }

    public function notesAttribuer()
    {
        return $this->hasMany('App\Model\Note', 'noteur_id');
    }

}